<?php

define('FILES_DIR', __DIR__ . '/resources/');
require_once __DIR__ . '/../data_store.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if (empty($_FILES['file']['tmp_name']) || empty($_FILES['file']['name'])) {
        $message = 'ファイルが選択されていません';
        $error = 'class="error"';
    } else {
        list($origin_name, $file_type) = explode('.', $_FILES['file']['name']);

        $filename = bin2hex(openssl_random_pseudo_bytes(16)) . '_' . $origin_name . '.' . $file_type;

        $upload_success = move_uploaded_file($_FILES['file']['tmp_name'], FILES_DIR . $filename);

        $store_result = store($_FILES['file']['name'], $filename, $_FILES["file"]["type"], date("Y-m-d H:i:s"));

        if ($upload_success && $store_result) {
            $message = 'アップロードに成功しました。';
        } else {
            $message = 'アップロードに失敗しました。';
            $error = 'class="error"';
        }
    }
}

?>
<html>

<head>
    <title>PHP SAMPLE</title>
</head>

<body>
    <style>
        .error {
            color: #F00;
        }
    </style>
    <main>
        <h1>php file upload sample</h1>
        <?php if (isset($message)) : ?>
            <p <?= $error ?>><?= $message ?></p>
        <?php endif; ?>
        <form action="" enctype="multipart/form-data" method="post">
            <label for="file">ファイル: </label>
            <input id="file" type="file" name="file">
            <button type="submit">アップロード実行</button>
        </form>
    </main>
</body>

</html>