<?php
use PHPUnit\Framework\TestCase;
use PHPUnit\DbUnit\TestCaseTrait;
use PHPUnit\DbUnit\DataSet\YamlDataSet;
use app\src\Book;
use app\test\Generic_Tests_DatabaseTestCase;

class BookTest extends Generic_Tests_DatabaseTestCase
{
    public $book;
    
    protected function getDataSet()
    {
        $dataset = new YamlDataSet(dirname(__FILE__)."/../data/phpunit_dataset/BooksTest_fixture.yml");
        return $dataset;
    }

    public function testInsert()
    {
        $book = new Book(self::$pdo);
        $book->insert('title_test', 'author_test_example');

        $result = $this->getConnection()->getRowCount('books');
        $this->assertEquals(5, $result);
        
        // データ挿入後のデータセットを読み込み
        $after_dataset = new YamlDataSet(dirname(__FILE__)."/../data/phpunit_dataset/BooksTest_after_insert.yml");

        // // ファイルから読み込んだデータセットから、データテーブルを取得
        $expected = $after_dataset->getTable('books');

        $test = $this->getConnection()->createQueryTable(
            'books', 'SELECT * FROM books'
        );

        $this->assertTablesEqual($expected, $test);
    }

    public function testFindTitleById()
    {
        $book = new Book(self::$pdo);
        $result = $book->findTitleById(4);
        
        $this->assertEquals('なぜ?がわかるデータベース', $result);
    }

    public function testUpdate()
    {
        $book = new Book(self::$pdo);
        $result = $book->update('updated title', 'updated author', 1);
        
        // データ更新後のデータセットを読み込み
        $after_dataset = new YamlDataSet(dirname(__FILE__)."/../data/phpunit_dataset/BooksTest_after_update.yml");

        // // ファイルから読み込んだデータセットから、データテーブルを取得
        $expected = $after_dataset->getTable('books');

        $test = $this->getConnection()->createQueryTable(
            'books', 'SELECT * FROM books'
        );

        $this->assertTablesEqual($expected, $test);
    }
}