<?php

namespace app\src;

class Book
{
    protected $db;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function insert($title, $author)
    {
        $sql = "INSERT INTO books (title, author) VALUES (:title, :author)";
        $prepare = $this->db->prepare($sql);
        $prepare->bindValue(':title', $title, \PDO::PARAM_STR);
        $prepare->bindValue(':author', $author, \PDO::PARAM_STR);
        $prepare->execute();
    }

    public function findTitleById($id)
    {
        $sql = "SELECT title FROM books WHERE id = (:id)";
        $prepare = $this->db->prepare($sql);
        $prepare->bindValue(':id', $id, \PDO::PARAM_INT);
        $prepare->execute();
        $result = $prepare->fetch(\PDO::FETCH_ASSOC);
        return $result['title'];
    }

    public function update($title, $author, $id)
    {
        $sql = "UPDATE books SET title = (:title), author = (:author) WHERE id = (:id)";
        $prepare = $this->db->prepare($sql);
        $prepare->bindValue(':title', $title, \PDO::PARAM_STR);
        $prepare->bindValue(':author', $author, \PDO::PARAM_STR);
        $prepare->bindValue(':id', $id, \PDO::PARAM_INT);
        $prepare->execute();
    }
}